/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.util;

import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import com.ordana.immersive_weathering.blocks.LeafPileBlock;
import com.ordana.immersive_weathering.configs.CommonConfigs;
import com.ordana.immersive_weathering.mixins.accessors.BiomeAccessor;
import com.ordana.immersive_weathering.reg.ModBlocks;
import com.ordana.immersive_weathering.reg.ModParticles;
import com.ordana.immersive_weathering.reg.ModTags;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesTypeRegistry;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_2465;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class WeatheringHelper {
    public static final Supplier<BiMap<class_2248, class_2248>> FLOWERY_BLOCKS = Suppliers.memoize(() -> {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder().put((Object)class_2246.field_28679, (Object)class_2246.field_28678).put((Object)class_2246.field_28674, (Object)class_2246.field_28673).put((Object)((class_2248)ModBlocks.LEAF_PILES.get(LeavesTypeRegistry.getValue((class_2960)new class_2960("flowering_azalea")))), (Object)((class_2248)ModBlocks.LEAF_PILES.get(LeavesTypeRegistry.getValue((class_2960)new class_2960("azalea")))));
        WeatheringHelper.addOptional((ImmutableBiMap.Builder<class_2248, class_2248>)builder, "quark:flowering_azalea_hedge", "quark:azalea_hedge");
        WeatheringHelper.addOptional((ImmutableBiMap.Builder<class_2248, class_2248>)builder, "quark:flowering_azalea_leaf_carpet", "quark:azalea_leaf_carpet");
        return builder.build();
    });
    public static final Supplier<Map<class_2248, LeafPileBlock>> LEAVES_TO_PILES = Suppliers.memoize(() -> {
        ImmutableMap.Builder b = ImmutableMap.builder();
        ModBlocks.LEAF_PILES.forEach((key, value) -> b.put((Object)key.leaves, (Object)value));
        return b.build();
    });
    public static final Supplier<Map<class_2248, class_2400>> LEAVES_TO_PARTICLE = Suppliers.memoize(() -> {
        ImmutableMap.Builder b = ImmutableMap.builder();
        ModParticles.FALLING_LEAVES_PARTICLES.forEach((key, value) -> b.put((Object)key.leaves, value));
        return b.build();
    });
    public static final Supplier<Map<class_2248, class_2394>> LOG_TO_PARTICLES = Suppliers.memoize(() -> ImmutableMap.builder().put((Object)class_2246.field_10431, (Object)((class_2394)ModParticles.OAK_BARK.get())).put((Object)class_2246.field_10010, (Object)((class_2394)ModParticles.DARK_OAK_BARK.get())).put((Object)class_2246.field_10037, (Object)((class_2394)ModParticles.SPRUCE_BARK.get())).put((Object)class_2246.field_10511, (Object)((class_2394)ModParticles.BIRCH_BARK.get())).put((Object)class_2246.field_10306, (Object)((class_2394)ModParticles.JUNGLE_BARK.get())).put((Object)class_2246.field_10533, (Object)((class_2394)ModParticles.ACACIA_BARK.get())).put((Object)class_2246.field_37545, (Object)((class_2394)ModParticles.MANGROVE_BARK.get())).put((Object)class_2246.field_22118, (Object)((class_2394)ModParticles.NETHER_SCALE.get())).put((Object)class_2246.field_22111, (Object)((class_2394)ModParticles.NETHER_SCALE.get())).put((Object)class_2246.field_10126, (Object)((class_2394)ModParticles.OAK_BARK.get())).put((Object)class_2246.field_10178, (Object)((class_2394)ModParticles.DARK_OAK_BARK.get())).put((Object)class_2246.field_10155, (Object)((class_2394)ModParticles.SPRUCE_BARK.get())).put((Object)class_2246.field_10307, (Object)((class_2394)ModParticles.BIRCH_BARK.get())).put((Object)class_2246.field_10303, (Object)((class_2394)ModParticles.JUNGLE_BARK.get())).put((Object)class_2246.field_9999, (Object)((class_2394)ModParticles.ACACIA_BARK.get())).put((Object)class_2246.field_37549, (Object)((class_2394)ModParticles.MANGROVE_BARK.get())).put((Object)class_2246.field_22505, (Object)((class_2394)ModParticles.NETHER_SCALE.get())).put((Object)class_2246.field_22503, (Object)((class_2394)ModParticles.NETHER_SCALE.get())).build());

    public static void addOptional(ImmutableBiMap.Builder<class_2248, class_2248> map, String moddedId, String moddedId2) {
        Optional o1 = class_2378.field_11146.method_17966(new class_2960(moddedId));
        Optional o2 = class_2378.field_11146.method_17966(new class_2960(moddedId2));
        if (o1.isPresent() && o2.isPresent()) {
            map.put((Object)((class_2248)o1.get()), (Object)((class_2248)o2.get()));
        }
    }

    public static Optional<class_2680> getAzaleaGrowth(class_2680 state) {
        return Optional.ofNullable((class_2248)FLOWERY_BLOCKS.get().inverse().get((Object)state.method_26204())).map(block -> block.method_34725(state));
    }

    public static Optional<class_2680> getAzaleaSheared(class_2680 state) {
        return Optional.ofNullable((class_2248)FLOWERY_BLOCKS.get().get((Object)state.method_26204())).map(block -> block.method_34725(state));
    }

    public static class_2394 getBarkParticle(class_2680 state) {
        return LOG_TO_PARTICLES.get().getOrDefault(state.method_26204(), (class_2394)new class_2388(class_2398.field_11217, state));
    }

    public static Optional<class_2248> getFallenLeafPile(class_2680 state) {
        class_2248 b = state.method_26204();
        if (CommonConfigs.LEAF_PILES_BLACKLIST.get().contains(class_2378.field_11146.method_10221((Object)b).toString())) {
            return Optional.empty();
        }
        return Optional.ofNullable((class_2248)LEAVES_TO_PILES.get().get(b));
    }

    public static Optional<class_2400> getFallenLeafParticle(class_2680 state) {
        class_2248 b = state.method_26204();
        return Optional.ofNullable(LEAVES_TO_PARTICLE.get().get(b));
    }

    @Nullable
    public static class_1792 getBarkToStrip(class_2680 normalLog) {
        WoodType woodType = (WoodType)BlockSetAPI.getBlockTypeOf((class_1935)normalLog.method_26204(), WoodType.class);
        if (woodType != null) {
            boolean log = false;
            String childKey = woodType.getChildKey((Object)normalLog.method_26204());
            if ("log".equals(childKey) && woodType.getChild("stripped_log") != null || "wood".equals(childKey) && woodType.getChild("stripped_wood") != null) {
                log = true;
            }
            if (log) {
                Optional bark;
                String s = CommonConfigs.GENERIC_BARK.get();
                if (!s.isEmpty() && (bark = class_2378.field_11142.method_17966(new class_2960(s))).isPresent()) {
                    return (class_1792)bark.get();
                }
                return woodType.getItemOfThis("immersive_weathering:bark");
            }
        }
        return null;
    }

    public static Optional<Pair<class_1792, class_2248>> getBarkForStrippedLog(class_2680 stripped) {
        WoodType woodType = (WoodType)BlockSetAPI.getBlockTypeOf((class_1935)stripped.method_26204(), WoodType.class);
        if (woodType != null) {
            Object log = null;
            if (woodType.getChild("stripped_log") == stripped.method_26204()) {
                log = woodType.getChild("log");
            } else if (woodType.getChild("stripped_wood") == stripped.method_26204()) {
                log = woodType.getChild("wood");
            }
            if (log instanceof class_2248) {
                class_2248 unStripped = (class_2248)log;
                String s = CommonConfigs.GENERIC_BARK.get();
                if (!s.isEmpty()) {
                    Optional bark = class_2378.field_11142.method_17966(new class_2960(s));
                    if (bark.isPresent()) {
                        return Optional.of(Pair.of((Object)((class_1792)bark.get()), (Object)unStripped));
                    }
                } else {
                    class_1792 bark = woodType.getItemOfThis("immersive_weathering:bark");
                    if (bark != null) {
                        return Optional.of(Pair.of((Object)bark, (Object)unStripped));
                    }
                }
            }
        }
        return Optional.empty();
    }

    public static List<class_2338> grabBlocksAroundRandomly(class_2338 centerPos, int radiusX, int radiusY, int radiusZ) {
        ArrayList<class_2338> list = new ArrayList<class_2338>(class_2338.method_25998((class_2338)centerPos, (int)radiusX, (int)radiusY, (int)radiusZ).map(class_2338::new).toList());
        Collections.shuffle(list, new Random(class_3532.method_15389((class_2382)centerPos)));
        return list;
    }

    public static boolean hasEnoughBlocksAround(class_2338 centerPos, int radiusX, int radiusY, int radiusZ, class_1937 level, Predicate<class_2680> blockPredicate, int requiredAmount) {
        List<class_2338> lis = WeatheringHelper.grabBlocksAroundRandomly(centerPos, radiusX, radiusY, radiusZ);
        int count = 0;
        for (class_2338 pos : lis) {
            if (blockPredicate.test(level.method_8320(pos))) {
                ++count;
            }
            if (count < requiredAmount) continue;
            return true;
        }
        return false;
    }

    public static boolean hasEnoughBlocksAround(class_2338 centerPos, int radius, class_1937 level, Predicate<class_2680> blockPredicate, int requiredAmount) {
        return WeatheringHelper.hasEnoughBlocksAround(centerPos, radius, radius, radius, level, blockPredicate, requiredAmount);
    }

    public static boolean hasEnoughBlocksFacingMe(class_2338 centerPos, class_1937 level, Predicate<class_2680> blockPredicate, int requiredAmount) {
        int count = 0;
        ArrayList<class_2350> list = new ArrayList<class_2350>(List.of(class_2350.values()));
        Collections.shuffle(list, new Random(class_3532.method_15389((class_2382)centerPos)));
        for (class_2350 dir : list) {
            class_2338 pos = centerPos.method_10093(dir);
            if (blockPredicate.test(level.method_8320(pos))) {
                ++count;
            }
            if (count < requiredAmount) continue;
            return true;
        }
        return false;
    }

    public static boolean isLog(class_2680 state) {
        return state.method_26164(class_3481.field_15475) && (!state.method_28498((class_2769)class_2465.field_11459) || state.method_11654((class_2769)class_2465.field_11459) == class_2350.class_2351.field_11052) && !class_2378.field_11146.method_10221((Object)state.method_26204()).method_12832().contains("stripped");
    }

    public static boolean isIciclePos(class_2338 pos) {
        int rarity = CommonConfigs.ICICLE_RARITY.get();
        if (rarity == 1001) {
            return false;
        }
        Random posRandom = new Random(class_3532.method_15389((class_2382)pos));
        return posRandom.nextInt(rarity) == 0;
    }

    public static boolean isRandomWeatheringPos(class_2338 pos) {
        Random posRandom = new Random(class_3532.method_15389((class_2382)pos));
        return posRandom.nextInt(6) == 0;
    }

    public static void onFireExpired(class_3218 serverLevel, class_2338 pos, class_2680 state) {
    }

    @Nullable
    public static class_2680 getCharredState(class_2680 state) {
        class_2248 charred = null;
        if (state.method_26164(class_3481.field_17619)) {
            charred = ModBlocks.CHARRED_FENCE.get();
        } else if (state.method_26164(class_3481.field_25147)) {
            charred = ModBlocks.CHARRED_FENCE_GATE.get();
        } else if (state.method_26164(class_3481.field_15468)) {
            charred = ModBlocks.CHARRED_SLAB.get();
        } else if (state.method_26164(class_3481.field_15502)) {
            charred = ModBlocks.CHARRED_STAIRS.get();
        } else if (state.method_26164(class_3481.field_15471)) {
            charred = ModBlocks.CHARRED_PLANKS.get();
        } else if (state.method_26164(class_3481.field_23210)) {
            charred = ModBlocks.CHARRED_LOG.get();
        }
        if (charred == null) {
            return null;
        }
        return charred.method_34725(state);
    }

    public boolean ashStuff(class_2680 state, class_1937 level, class_2338 pos) {
        class_2680 downState = level.method_8320(pos.method_10074());
        if (!(level.field_9229.method_43057() > 0.2f) && downState.method_27852(class_2246.field_10219)) {
            return level.method_8501(pos.method_10074(), class_2246.field_10566.method_9564());
        }
        return false;
    }

    public static float getTemp(class_1937 level, class_2338 pos) {
        class_1959 biome = (class_1959)level.method_23753(pos).comp_349();
        return ((BiomeAccessor)biome).invokeGetTemperature(pos);
    }

    public static boolean isPosWet(class_1937 level, class_6880<class_1959> biome, class_2338 pos) {
        return biome.method_40220(ModTags.WET);
    }

    public static boolean isPosHot(class_1937 level, class_6880<class_1959> biome, class_2338 pos) {
        return biome.method_40220(ModTags.HOT);
    }

    public static boolean shouldGetWet(class_3218 world, class_2338 pos) {
        int temperature = 0;
        boolean isTouchingWater = false;
        for (class_2350 direction : class_2350.values()) {
            class_2338 targetPos = pos.method_10093(direction);
            class_6880 biome = world.method_23753(pos);
            class_2680 neighborState = world.method_8320(targetPos);
            if (neighborState.method_26227().method_15767(class_3486.field_15517)) {
                isTouchingWater = true;
                break;
            }
            if (world.method_8520(pos.method_10093(direction))) {
                --temperature;
                continue;
            }
            if (neighborState.method_26164(ModTags.MAGMA_SOURCE) || world.method_8597().comp_644()) {
                ++temperature;
                continue;
            }
            if (WeatheringHelper.isPosWet((class_1937)world, (class_6880<class_1959>)biome, pos)) {
                --temperature;
                continue;
            }
            if (!WeatheringHelper.isPosHot((class_1937)world, (class_6880<class_1959>)biome, pos)) continue;
            ++temperature;
        }
        return temperature < 0 || isTouchingWater;
    }

    public static void applyFreezing(class_1297 entity, int freezingIncrement) {
        WeatheringHelper.applyFreezing(entity, freezingIncrement, false);
    }

    public static void applyFreezing(class_1297 entity, int freezingIncrement, boolean inWater) {
        class_1309 le;
        if (entity instanceof class_1657) {
            boolean bl = true;
        }
        if (freezingIncrement != 0 && entity.method_32316() && entity instanceof class_1309 && class_1890.method_8203((class_1887)class_1893.field_9122, (class_1309)(le = (class_1309)entity)) <= 0 && !entity.method_5864().method_20210(ModTags.LIGHT_FREEZE_IMMUNE)) {
            if (inWater ? le.method_6118(class_1304.field_6166).method_31574(class_1802.field_8370) : le.method_6059(class_1294.field_5927)) {
                return;
            }
            entity.method_32317(Math.min(entity.method_32315(), entity.method_32312() + freezingIncrement));
        }
    }

    public static void growHangingRoots(class_3218 world, class_5819 random, class_2338 pos) {
        class_2680 newState;
        class_2350 dir = class_2350.values()[1 + random.method_43048(5)].method_10153();
        class_2338 targetPos = pos.method_10093(dir);
        class_2680 targetState = world.method_8320(targetPos);
        if (targetState.method_26215()) {
            return;
        }
        class_2680 class_26802 = newState = dir == class_2350.field_11033 ? class_2246.field_28686.method_9564() : (class_2680)ModBlocks.HANGING_ROOTS_WALL.get().method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)dir);
        if (targetState.method_27852(class_2246.field_10382)) {
            newState = (class_2680)newState.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(true));
        }
        world.method_8501(targetPos, newState);
    }
}

